;Copyright 1996 by Henter-Joyce, Inc.
;Windows calculator macros, 3/30/96, th & esd
;please note: this file contains only the standard macros.
;the scientific macros are in the file calc1.jms.
;any changes made to this file will necessitate that calc.jms be recompiled.
;Converted to JFW 3.0 5/15/97, cw

include "calc95.jsm"
Include "hjconst.jsh"

Function AutoStartEvent ()
if GetVerbosity() == 0 then
Say(msg79, ot_help) ;"Press Insert plus H for Jaws Hot Keys with standard and"
Say(msg80, ot_help) ;"scientific calculators"
Endif
EndFunction

Script  ScriptFileName()
ScriptAndAppNames ("Calculator")
EndScript

Function GetDisplay ()
;this macro gets the value in the display.  It is called by all other macros.
SaveCursor()
RouteInvisibleToPC()
InvisibleCursor()
JawsPageUp()
JawsHome()
NextLine()
NextLine()
NextWord()
SayChunk()
RestoreCursor()
EndFunction

Script  SayDisplay()
; Read the value in the display
GetDisplay()
if GetVerbosity() == 0 then
Say(msg84, ot_message) ;"Currently in Display"
EndIf
if GetVerbosity() == 1 then
Say(msg85, ot_message) ;"Displayed"
EndIf
EndScript

Script ClearCalculatorDisplay ()
; Clear Calculator
{Escape}
Say(msg86, ot_message) ;"Clear"
EndScript

Script  CopyDisplayToClipboard()
;copy value from display to clipboard
{control+C}
GetDisplay()
Say(msg87, ot_message) ;"copied to clipboard from the display"
EndScript

Script ExecuteProcess ()
; Perform function and put value in Display
{=}
Say(msg89, ot_message) ;"Equals"
GetDisplay()
EndScript


Script JAWSBackSpace ()
; Delete the last value typed
{BackSpace}
Say(msg90, ot_message) ;"Back One"
EndScript

Script  Reciprocal()
; Perform the Reciprocal Function
if Menusactive()==true then
{r}
else
{R}
Say(msg91, ot_message) ;"Reciprical"
GetDisplay()
Endif
EndScript

Script  RecallValueFromMemory()
; Recall value currently stored in Memory
{Control+R}
if GetVerbosity() == 0 then
Say(msg94, ot_message) ;"Recalled from Memory"
EndIf
if GetVerbosity() == 1 then
Say(msg95, ot_message) ;"Recalled"
EndIf
GetDisplay()
EndScript

Script  AddDisplayToMemory()
; Add Displayed value to Memory value and store new value in Memory
{Control+P}
GetDisplay()
if GetVerbosity() == 0 then
Say(msg96, ot_message) ;"Added to Value in Memory"
EndIf
if GetVerbosity() == 1 then
Say(msg97, ot_message) ;"Added"
EndIf
EndScript

Script  ClearMemory()
; Clear value from Memory
{Control+L}
if GetVerbosity() == 0 then
Say(msg98, ot_message) ;"Cleared Value from Memory"
EndIf
if GetVerbosity() == 1 then
Say(msg99, ot_message) ;"Memory Cleared"
EndIf
if GetVerbosity() == 2 then
Say(msg99, ot_message) ;"Memory Cleared"
EndIf
EndScript

Script  SignToggle()
; Changes "sign" of Displayed value
{F9}
if GetVerbosity() == 0 then
Say(msg100, ot_message) ;"Sign changed"
EndIf
GetDisplay()
EndScript

Script  SquareRoot()
; Perform Square or square root operation on Displayed Value
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom,s_unrestricted))==0  then
Say(msg101, ot_message) ;"square root"
else
Say(msg102, ot_message) ;"square"
Endif
{Shift+2}
GetDisplay()
EndScript

Script  StoreDisplayToMemory()
; Speak and Store Displayed value in Memory
if Menusactive()==true then
{s}
else
{Control+M}
if GetVerbosity() == 0 then
Say(msg92, ot_message) ;"Stored in Memory"
EndIf
if GetVerbosity() == 1 then
Say(msg93, ot_message) ;"Stored"
EndIf
GetDisplay()
Endif
EndScript

Script  WhichCalculator()
;determine which calculator is turned on
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
PcCursor()
Say(msg104, ot_message) ;"scientific calculator"
else
Say(msg105, ot_message) ;"standard calculator"
Endif
PcCursor()
EndScript

Script  CalculatorToggle()
;toggle between scientific and standard modes
var
int echo,;
int verb
let echo=GetScreenecho();
let verb=GetVerbosity();
while GetScreenEcho()>0
ScreenEcho()
Endwhile
while GetVerbosity()<2
VerbosityLevel()
Endwhile
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
PcCursor ()
{alt+v}
{t}
while GetScreenecho()!=echo
ScreenEcho()
Endwhile
while GetVerbosity()!=verb
VerbosityLevel()
Endwhile
if getverbosity()==0 then
Say(msg106, ot_message) ;"The standard calculator has been turned on"
else
if getverbosity()==1 then
Say(msg107, ot_message) ;"Standard calculator on"
else
if getverbosity()==2 then
Say(msg105, ot_message) ;"standard calculator"
endif
endif
endif
Else
{alt+v}
{s}
while GetScreenecho()!=echo
ScreenEcho()
Endwhile
while GetVerbosity()!=verb
VerbosityLevel()
Endwhile
if getverbosity()==0 then
Say(msg108, ot_message) ;"The scientific calculator has been turned on"
else
if getverbosity()==1 then
Say(msg109, ot_message) ;"scientific calculator on"
else
if getverbosity()==2 then
Say(msg104, ot_message) ;"scientific calculator"
endif
endif
endif
endif
EndScript

Script  HotKeyHelp()
Say(msg1, ot_help) ;"use the following hot keys with Standard or scientific calculator"
Say(msg2, ot_help) ;"To toggle between standard and scientific calculators,"
Say(msg3 + GetScriptKeyname ("CalculatorToggle"), ot_help) ;"use the letter z"
Say(msg4 + GetScriptKeyName ("SayWindowTitle"), ot_help) ;"to find out which calculator is active, use insert plus t"
Say(msg5 + GetScriptKeyName ("SayDisplay"), ot_help) ;"to read the value in the display, use d"
Say(msg6, ot_help) ;"to put the result of a calculation in the display,"
Say(msg7 + GetScriptKeyName ("ExecuteProcess"), ot_help) ;"use the letter e as in echo"
Say(msg9 + GetScriptKeyName ("ClearCalculatorDisplay"), ot_help) ;"to clear the display, use alt plus d"
Say(msg11 + GetScriptKeyName ("ClearMemory"), ot_help) ;"To clear the memory, use alt+c"
Say(msg12 + GetScriptKeyName ("StoreDisplayToMemory"), ot_help) ;"To store displayed value in memory, use S"
Say(msg13 + GetScriptKeyName ("AddDisplayToMemory"), ot_help) ;"To add displayed value to value in memory, use a"
Say(msg14 + GetScriptKeyName ("RecallValueFromMemory"), ot_help) ;"To recall value from memory, use alt+r"
Say(msg15 + GetScriptKeyName ("SignToggle"), ot_help) ;"To change the sign of displayed value, use n"
Say(msg16 + GetScriptKeyName ("Reciprocal"), ot_help) ;"To get reciprocal of displayed value, use R"
Say(msg17 + GetScriptKeyName ("SquareRoot"), ot_help) ;"To get square root of displayed value, use q"
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, 1,0)) then
PcCursor()
Say(msg19, ot_help) ;"The following hotkeys are for use with the scientificcalculator"
Say(msg20, ot_help) ;"To enter hexidecimal numbers, use f5"
Say(msg21, ot_help) ;"When in hex mode, to enter the value A, use insert+a"
Say(msg22, ot_help) ;"When in hex mode, to enter the value b, use insert+b"
Say(msg23, ot_help) ;"When in hex mode, to enter the value c, use insert+c"
Say(msg24, ot_help) ;"When in hex mode, to enter the value d, use insert+d"
Say(msg25, ot_help) ;"When in hex mode, to enter the value e, use insert+e"
Say(msg26, ot_help) ;"When in hex mode, to enter the value f, use insert+f"
Say(msg27, ot_help) ;"To enter decimal numbers, use f6"
Say(msg28, ot_help) ;"to enter octal numbers, use f7"
Say(msg29, ot_help) ;"To enter binary numbers, use f8"
Say(msg30, ot_help) ;"To convert numbers to the decimal number system, use shift+d"
Say(msg31, ot_help) ;"To convert numbers to the hexidecimal number system, use shift+h"
Say(msg32, ot_help) ;"To convert numbers to the octal number system, use shift+o"
Say(msg33, ot_help) ;"To convert numbers to the binary number system, use shift+b"
Say(msg34, ot_help) ;"To do trigonometric functions with degrees, use f2"
Say(msg35, ot_help) ;"To do trigonometric functions with radians, use f3"
Say(msg36, ot_help) ;"To do trigonometric functions with gradients, use f4"
Say(msg37, ot_help) ;"To get the sine of a value, use shift+s"
Say(msg38, ot_help) ;"To get the arc sine of the displayed value, use alt+s"
Say(msg39, ot_help) ;"To get the hyperbolic sine of the displayed value, use control+s"
Say(msg40, ot_help) ;"to get arc hyperbolic sine of displayed value, use shift+control+s"
Say(msg41, ot_help) ;"To get the cosine of displayed value, use o"
Say(msg42, ot_help) ;"To get the arc cosine of displayed value, use alt+o"
Say(msg43, ot_help) ;"To get hyperbolic cosine of display, use control+o"
Say(msg44, ot_help) ;"To get arc hyperbolic cosine, use shift+control+o"
Say(msg45, ot_help) ;"To get the tangent of displayed value, use t"
Say(msg46, ot_help) ;"To get arc tangent of the display, use alt+t"
Say(msg47, ot_help) ;"To get hyperbolic tangent of display, use control+t"
Say(msg46, ot_help) ;"To get arc tangent of the display, use alt+t"
Say(msg47, ot_help) ;"To get hyperbolic tangent of display, use control+t"
Say(msg48, ot_help) ;"To get arc hyperbolic tangent, use shift+control+t"
Say(msg49 + GetScriptKeyName ("ScientificNotationToggle"), ot_help) ;"To convert display to or from scientific notation, use v"
Say(msg50, ot_help) ;"To convert display to degree-minute-second format, use m"
Say(msg51, ot_help) ;"To convert display from degree-minute-second format, use shift+m"
Say(msg52  + GetScriptKeyName ("CommonLogDisplay"), ot_help) ;"To get the common logarithm of displayed value, use l"
Say(msg53 + GetScriptKeyName ("TenToXth"), ot_help) ;"To get 10 to the x power, use alt+l"
Say(msg54 + GetScriptKeyName ("EToXth"), ot_help) ;"To get E to the x power, use shift+e"
Say(msg55 + GetScriptKeyName ("NaturalLogDisplay"), ot_help) ;"To get the natural logarithm of displayed value, use alt+e"
Say(msg56+ GetScriptKeyName ("FactorialDisplay"), ot_help) ;"To get factorial of display, use shift+1"
Say(msg57+ GetScriptKeyName ("GetIntegerPartOfDisplay"), ot_help) ;"To get integer part of display, use i"
Say(msg58 + GetScriptKeyName ("GetFractionalPartOfDisplay"), ot_help) ;"To get fractional part of display, use shift+f"
Say(msg17 + GetScriptKeyName ("SquareRoot"), ot_help) ;"To get square root of displayed value, use q"
Say(msg59 + GetScriptKeyName ("SquareDisplay"), ot_help) ;"To get square of displayed value, use alt+q"
Say(msg60 + GetScriptKeyName ("CubeDisplay"), ot_help) ;"To get cube of displayed value, use shift+3"
Say(msg61 + GetScriptKeyName ("CubeRootDisplay"), ot_help) ;"To get cube root of displayed value, use alt+3"
EndIf
EndScript

;**********************************************************************
;this section contains numeric, scientific functions.
;any alteration makes recompilation of the entire set necessary.
Script  SquareDisplay()
;Get the square of display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom,s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18,  s_bottom,s_unrestricted)) then
{shift+2}
Say(msg65, ot_message) ;"Square "
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PCCursor()
Endif
EndScript


Script  FactorialDisplay()
;get the factorial of the displayed value
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{;}
Say(msg66, ot_message) ;"factorial"
{shift+1}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  GetIntegerPartOfDisplay()
;get the integer part of the displayed value
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{;}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  NaturalLogDisplay()
;get the natural (base e) logarithm of the displayed value
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{n}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  CommonLogDisplay()
;get the common (base 10) logarithm of the displayed value
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{l}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  TenToXth()
;get 10 to the x power, where x is in the display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{i}
{l}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  EToXth()
;get e to the x power, where x is in the display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{i}
{n}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  GetFractionalPartOfDisplay()
;get the fractional part of the display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
Say(msg67, ot_message) ;"fractional part of display"
{i}
{;}
RouteJAWStoPC()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  HexidecimalMode()
;put the calculator in hexadecimal mode
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{f5}
if Getverbosity()==0 then
Say(msg68, ot_message) ;"calculator in hexadecimal mode"
Endif
if Getverbosity()>0 then
Say(msg69, ot_message) ;"hexidecimal mode"
Endif
Endif
EndScript

Script  DecimalMode()
;put the calculator in decimal mode
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{f6}
if Getverbosity()==0 then
Say(msg70, ot_message) ;"calculator in decimal mode"
else
Say(msg71, ot_message) ;"decimal mode"
Endif
Endif
EndScript

Script  OctalMode()
;put the calculator in octal mode
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{f7}
if Getverbosity()==0 then
Say(msg72, ot_message) ;"calculator in octal mode"
else
Say(msg73, ot_message) ;"octal mode"
Endif
Endif
EndScript

Script  BinaryMode()
;put the calculator in binary mode
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{f8}
if Getverbosity()==0 then
Say(msg74, ot_message) ;"calculator in binary mode"
else
Say(msg75, ot_message) ;"binary mode"
Endif
Endif
EndScript


Script  ScientificNotationToggle()
;toggle the display between decimal and scientific notation
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
{v}
RouteJawsToPc()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  CubeDisplay()
;get the cube of the display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
Say(msg76, ot_message) ;"to the third power"
{shift+3}
RouteJawsToPc()
JawsCursor()
JawsPageUp()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript

Script  CubeRootDisplay()
;get the cube root of the display
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted))==0  then
if getverbosity()==0 then
Say(msg62, ot_message) ;"You must turn on the scientific calculator to use this macro"
else
if getverbosity()==1 then
Say(msg63, ot_message) ;"not in scientific mode"
else
if getverbosity()==2 then
Say(msg64, ot_message) ;"not available"
endif
endif
endif
endif
;fs18="inv"
if (FindString(GetRealwindow(getcurrentwindow()), fs18, s_bottom, s_unrestricted)) then
JawsCursor()
Jawspageup()
NextLine()
NextLine()
Say(msg77, ot_message) ;"the cube root of "
SayLine()
Say(msg78, ot_message) ;"is "
{i}
{shift+3}
RouteJawsToPc()
JawsCursor()
JawsPageup()
NextLine()
NextLine()
SayLine()
PcCursor()
Endif
EndScript


Script SayDisplayEnter ()
If (MenusActive() || DialogActive ()) then
  {enter}
  Return
Else 
  {=}
  PerformScript SayDisplay ()
EndIf  


EndScript


Script SayLine ()

If (!IsPCCursor () || MenusActive () || DialogActive ()) then
  PerformScript SayLine()
  Return 
Else 
  PerformScript SayDisplay ()
endIf

EndScript
